%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 9.4
% File; cond_median.m
% Coded by: Dawit Zerom
%
% Computing conditional MEDIAN forecasts. 
%
% Reference:
% De Gooijer, J.G. and Zerom, D. (2000).
%    Kernel based multi-step-ahead prediction of the U.S. 
%    short-term interest rate. 
%    Journal of Forecasting, 19(4), 335-353.
%    DOI: 10.1002/1099-131x(200007)19:4\%3C335::aid-for777\%3E3.3.co;2-v
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load    = waiting.dat;
datan   = waiting;
[nr,nc] = size(datan);
data1   = datan; 
k       = 1;    % max Markov order
mx      = 10;   % maximum forecast horizon   
x1      = data1(k:nr);
data    = x1;
z       = data;
n2      = 289;     % Start data set Geyser-waiting time
n3      = 289;     
df      = n3-n2+1; 
n       = n2;
while n<=n3 
    m = 1;        
    while m<=mx;
        n0    = n-m;
        y     = z(m+1:n,1);
        x0    = z(1:n0);
        sd    = std(data1(1:n));
        hop   = (sd)*((n)^(-1/(k+4))); % optimal bandwidth          
        a     = min(y)-3*hop;
        b     = max(y)+3*hop;
        step  = (b-a)/256;           
        for l  = 1:256;
          sum1 = 0;
          sum2 = 0;
          t1   = 1;
          while t1 <= n0;
              vect1    = (z(n)-x0(t1))/hop;
              xx       = vect1*vect1';
              sum1     = sum1+(exp(-0.5*xx))*((2*pi)^(-k/2));
              if y(t1) <= (a+l*step)  
                 vect2 =  (z(n)-x0(t1))/hop;
                 xx2   =  vect2*vect2'; 
                 sum2  =  sum2+(exp(-0.5*xx2))*((2*pi)^(-k/2));
              end
              t1 = t1+1;
           end  
           if(sum1 ==0 )
             sum1 = 1.0e-300;
           end
           if (sum2/sum1) > 0.5   % Median
             break
           end
         end   
         ztmedian(n,m) = a+l*step;
         dif(n,m)      = data1(n+m,1)-ztmedian(n,m);
         m             = m+1;
    end       
    n = n+1;
end              
dif_median   = dif(n2:n3,1:mx);             % Resize matrix
MSFE_median  = sum(dif_median*dif_median')/mx;        
RMAFE_median = (100/mx)*sum(abs(dif_median)'./abs(data1(n2+1:nr,1)));
